; GameShot.s : Q[ʁ^Vbg
;



; W[錾
;
    .module Game


; Qƃt@C
;
    .include    "bios.inc"
    .include    "System.inc"
    .include	"App.inc"
    .include    "Game.inc"
    .include    "GameShip.inc"
    .include    "GameShot.inc"



; CODE ̈
;
    .area   _CODE


; Vbg
;
_GameShotInitialize::
    
    ; Vbg̑
    ld      ix, #_gameShot
    ld      de, #GAME_SHOT_PARAM_SIZE
    ld      bc, #((GAME_SHOT_SIZE << 8) | 0x0000)
0$:
    
    ; CfbNX̐ݒ
    ld      GAME_SHOT_PARAM_INDEX(ix), c
    
    ; Ԃ̐ݒ
    ld      a, #GAME_SHOT_STATE_NULL
    ld      GAME_SHOT_PARAM_STATE(ix), a
    xor     a
    ld      GAME_SHOT_PARAM_PHASE(ix), a
    
    ; ̃Vbg
    add     ix, de
    inc     c
    djnz    0$
    
    ; I
    ret


; VbgXV
;
_GameShotUpdate::
    
    ; Vbg̑
    ld      ix, #_gameShot
    ld      b, #GAME_SHOT_SIZE
GameShotUpdateLoop:
    
    ; WX^̕ۑ
    push    bc
    
    ; Ԃ̎擾
    ld      a, GAME_SHOT_PARAM_STATE(ix)
    
    ; Ȃ
    cp      #GAME_SHOT_STATE_NULL
    jr      nz, 0$
    call    GameShotNull
    jr      GameShotUpdateNext
0$:
    
    ; ړ
    cp      #GAME_SHOT_STATE_MOVE
    jr      nz, 1$
    call    GameShotMove
    jr      GameShotUpdateNext
1$:
    
    ; ̃Vbg
GameShotUpdateNext:
    pop     bc
    ld      de, #GAME_SHOT_PARAM_SIZE
    add     ix, de
    djnz    GameShotUpdateLoop
    
    ; XV̏I
GameShotUpdateEnd:
    
    ; I
    ret


; Vbg͂Ȃ
;
GameShotNull:
    
    ; Ԃ̎擾
    ld      a, GAME_SHOT_PARAM_PHASE(ix)
    or      a
    jr      nz, GameShotNullMain
    
    ; Ԃ̍XV
    inc     GAME_SHOT_PARAM_PHASE(ix)
    
    ; ҋ@̏
GameShotNullMain:
    
    ; ̊
GameShotNullDone:
    
    ; `̊Jn
    ld      c, GAME_SHOT_PARAM_INDEX(ix)
    sla     c
    sla     c
    ld      b, #0x00
    ld      hl, #(_sprite + GAME_SPRITE_SHOT)
    add     hl, bc
    ld      a, #0xc0
    ld      (hl), a
    inc     hl
    ld      (hl), a
    inc     hl
    ld      (hl), a
    inc     hl
    ld      (hl), a
    
    ; ̏I
GameShotNullEnd:
    
    ; I
    ret


; Vbgړ
;
GameShotMove:
    
    ; Ԃ̎擾
    ld      a, GAME_SHOT_PARAM_PHASE(ix)
    or      a
    jr      nz, GameShotMoveMain
    
    ; ʒȕ
    ld      a, (_gameShip + GAME_SHIP_PARAM_POINT_X)
    ld      GAME_SHOT_PARAM_POINT_X(ix), a
    ld      a, (_gameShip + GAME_SHIP_PARAM_POINT_Y)
    ld      GAME_SHOT_PARAM_POINT_Y(ix), a
    
    ; t̊Jn
    ld      hl, #mmlChannel0
    ld      (_soundRequest + 0), hl
    
    ; Ԃ̍XV
    inc     GAME_SHOT_PARAM_PHASE(ix)
    
    ; ړ̏
GameShotMoveMain:
    
    ; ړ
    ld      a, GAME_SHOT_PARAM_POINT_Y(ix)
    sub     #0x04
    ld      GAME_SHOT_PARAM_POINT_Y(ix), a
    
    ; ړ̊
    cp      #0xf0
    jr      c, GameShotMoveDone
    cp      #0xf9
    jr      nc, GameShotMoveDone
    
    ; Ԃ̍XV
    ld      a, #GAME_SHOT_STATE_NULL
    ld      GAME_SHOT_PARAM_STATE(ix), a
    xor     a
    ld      GAME_SHOT_PARAM_PHASE(ix), a
    
    ; ̊
GameShotMoveDone:
    
    ; `̊Jn
    ld      c, GAME_SHOT_PARAM_INDEX(ix)
    sla     c
    sla     c
    ld      b, #0x00
    ld      hl, #(_sprite + GAME_SPRITE_SHOT)
    add     hl, bc
    ld      d, h
    ld      e, l
    ld      hl, #shotSpriteTable
    ld      b, GAME_SHOT_PARAM_POINT_X(ix)
    ld      c, GAME_SHOT_PARAM_POINT_Y(ix)
    call    _SystemSetSprite
    
    ; ̏I
GameShotMoveEnd:
    
    ; I
    ret


; VbgGg
;
_GameShotEntry::
    
    ; WX^̕ۑ
    push    bc
    push    de
    push    ix
    
    ; Vbg̑
    ld      ix, #_gameShot
    ld      de, #GAME_SHOT_PARAM_SIZE
    ld      b, #GAME_SHOT_SIZE
0$:
    ld      a, GAME_SHOT_PARAM_STATE(ix)
    cp      #GAME_SHOT_STATE_NULL
    jr      z, 1$
    add     ix, de
    djnz    0$
    jr      GameShotEntryEnd
1$:
    
    ; Ԃ̍XV
    ld      a, #GAME_SHOT_STATE_MOVE
    ld      GAME_SHOT_PARAM_STATE(ix), a
    xor     a
    ld      GAME_SHOT_PARAM_PHASE(ix), a
    
    ; Gg̏I
GameShotEntryEnd:
    
    ; WX^̕A
    pop     ix
    pop     de
    pop     bc
    
    ; I
    ret


; 萔̒`
;


; Vbgf[^
;
shotSpriteTable:
    
    .db     0xfc, 0xf8, 0x08, 0x0f

; MML f[^
;
mmlChannel0:
    
    .ascii  "T1V15L0"
    .ascii  "O5C#CC#RCO4BA#AG#GFD#C#O3BG#"
    .db     0x00



; DATA ̈
;
    .area   _DATA


; ϐ̒`
;

; p[^
;
_gameShot::
    
    .ds     GAME_SHOT_PARAM_SIZE * GAME_SHOT_SIZE



